/*
 * Decompiled with CFR 0.152.
 */
package ixtab.jailbreak.backend;

import ixtab.jailbreak.backend.JailbreakerPolicy;
import ixtab.jailbreak.backend.PermissionsEnumeration;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Enumeration;

class JailbreakerPermissions
extends PermissionCollection {
    private static final long serialVersionUID = 249538019500125910L;
    private PermissionCollection readable;
    private final JailbreakerPolicy parent;
    private final ProtectionDomain domain;

    public JailbreakerPermissions(JailbreakerPolicy parent, ProtectionDomain domain, PermissionCollection delegate) {
        this.parent = parent;
        this.domain = domain;
        this.readable = delegate;
    }

    private PermissionCollection writable() {
        return this.parent.getAdditionalPermissions(this.domain);
    }

    public void add(Permission permission) {
        PermissionCollection writable = this.writable();
        if (!writable.implies(permission)) {
            this.writable().add(permission);
        }
    }

    public boolean implies(Permission permission) {
        return this.writable().implies(permission) || this.readable.implies(permission);
    }

    public Enumeration elements() {
        return new PermissionsEnumeration(new Enumeration[]{this.readable.elements(), this.writable().elements()});
    }

    public void setReadOnly() {
        this.parent.clearAdditionalPermissions(this.domain);
    }

    public boolean isReadOnly() {
        return !this.writable().elements().hasMoreElements();
    }
}

